L.YahooTileLayer = function(url, options) {

  var tileLayer = new L.TileLayer(url, options);

  tileLayer.getTileUrl = function (tilePoint) {

    var zoom = this._getZoomForUrl();

    var shift = zoom - 1;
    var x = tilePoint.x;
    var y = Math.pow(2, shift) - 1 - tilePoint.y;
    
    this._adjustTilePoint(tilePoint);

    return L.Util.template(this._url, L.Util.extend({
      s: this._getSubdomain(tilePoint),
      z: zoom + 1,
      x: x,
      y: y
    }, this.options));
  };

  return tileLayer;
};

window.onload = function() {
  var now = new Date();  
  var year = now.getFullYear();  
  var month = now.getMonth() + 1;  
  var day = now.getDate();
  var hours = now.getHours();
  var minutes = now.getMinutes();

  if (month < 10) month = '0' + month;
  if (day < 10) day = '0' + day;
  if (hours < 10) hours = '0' + hours;
  minutes *= 0.1;
  minutes = Math.floor(minutes);
  minutes *= 10;
  if (minutes < 10) minutes = '0' + minutes;

  var googleLayer = new L.TileLayer('http://mt.google.com/vt/lyrs=m@176000000&hl=ja&src=api&x={x}&y={y}&z={z}&s=Ga&scale=1', {
    attribution: 'Google',
    minZoom: 4,
    maxZoom: 22
  });

  var urlFormat = 'http://weather.map.c.yimg.jp/weather?x={x}&y={y}&z={z}&size=256&date=' + year + month + day + hours + minutes;
  var yahooWeatherLayer = L.YahooTileLayer(urlFormat, {
    attribution: 'Yahoo',
    minZoom: 4,
    maxZoom: 19
  });

  var map = L.map('map', { layers: [googleLayer, yahooWeatherLayer], center: [34.066929, 134.559270], zoom: 8 });
};
