var earth;
function initialize() {
    var options = {atmosphere: true, center: [0, 0], zoom: 0};
    earth = new WE.map('earth_div', options);
    WE.tileLayer('http://otile{s}.mqcdn.com/tiles/1.0.0/sat/{z}/{x}/{y}.jpg', {
        subdomains: '1234',
        attribution: 'Tiles Courtesy of MapQuest'
    }).addTo(earth);
}

var markers = [];

// 四国88か所札所座標データ
var dataSet = [
	{ name: "霊山寺(１番札所)" ,longitude: 134.5029721, latitude: 34.1594736 },
	{ name: "極楽寺(２番札所)" ,longitude: 134.490328,  latitude: 34.155651 },
	{ name: "金泉寺(３番札所)" ,longitude: 134.4685312, latitude: 34.147457 },
	{ name: "大日寺(４番札所)" ,longitude: 134.4308346, latitude: 34.1513476 },
	{ name: "地蔵寺(５番札所)" ,longitude: 134.4319317, latitude: 34.1372461 },
	{ name: "安楽寺(６番札所)" ,longitude: 134.3882412, latitude: 34.11838 },
	{ name: "十楽寺(７番札所)" ,longitude: 134.3779212, latitude: 34.1207317 },
	{ name: "熊谷寺(８番札所)" ,longitude: 134.3400349, latitude: 34.1208041 },
	{ name: "法輪寺(９番札所)" ,longitude: 134.3337248, latitude: 34.1043725 },
	{ name: "切幡寺(１０番札所)" ,longitude: 134.3042772, latitude: 34.1078 },
	{ name: "藤井寺(１１番札所)" ,longitude: 134.348482, latitude: 34.0516509 },
	{ name: "焼山寺(１２番札所)" ,longitude: 134.3102179, latitude: 33.9849692 },
	{ name: "大日寺(１３番札所)" ,longitude: 134.4626688, latitude: 34.0381555 },
	{ name: "常楽寺(１４番札所)" ,longitude: 134.4756371, latitude: 34.050329 },
	{ name: "國分寺(１５番札所)" ,longitude: 134.4736012, latitude: 34.0556089 },
	{ name: "観音寺(１６番札所)" ,longitude: 134.4744705, latitude: 34.0685324 },
	{ name: "井戸寺(１７番札所)" ,longitude: 134.4851307, latitude: 34.0850498 },
	{ name: "恩山寺(１８番札所)" ,longitude: 134.5783282, latitude: 33.9859278 },
	{ name: "立江寺(１９番札所)" ,longitude: 134.6057632, latitude: 33.9678086 },
	{ name: "鶴林寺(２０番札所)" ,longitude: 134.5056342, latitude: 33.9139141 },
	{ name: "太龍寺(２１番札所)" ,longitude: 134.5212122, latitude: 33.8814082 },
	{ name: "平等寺(２２番札所)" ,longitude: 134.582752, latitude: 33.8519479 },
	{ name: "薬王寺(２３番札所)" ,longitude: 134.5276112, latitude: 33.7323478 },
	{ name: "最御崎寺(２４番札所)" ,longitude: 134.1755501, latitude: 33.249933 },
	{ name: "津照寺(２５番札所)" ,longitude: 134.148393, latitude: 33.2874626 },
	{ name: "金剛頂寺(２６番札所)" ,longitude: 134.122868, latitude: 33.307240 },
	{ name: "神峯寺(２７番札所)" ,longitude: 133.9744418, latitude: 33.4672585 },
	{ name: "大日寺(２８番札所)" ,longitude: 133.7054099, latitude: 33.5775771 },
	{ name: "国分寺(２９番札所)" ,longitude: 133.6404406, latitude: 33.598663 },
	{ name: "善楽寺(３０番札所)" ,longitude: 133.5774991, latitude: 33.5919114 },
	{ name: "竹林寺(３１番札所)" ,longitude: 133.5775637, latitude: 33.5470535 },
	{ name: "禅師峰寺(３２番札所)" ,longitude: 133.6116, latitude: 33.5268622 },
	{ name: "雪蹊寺(３３番札所)" ,longitude: 133.5430577, latitude: 33.5008218 },
	{ name: "種間寺(３４番札所)" ,longitude: 133.487528, latitude: 33.4917457 },
	{ name: "清滝寺(３５番札所)" ,longitude: 133.4097658, latitude: 33.5126362 },
	{ name: "青龍寺(３６番札所)" ,longitude: 133.452111, latitude: 33.4298097 },
	{ name: "岩本寺(３７番札所)" ,longitude: 133.1347659, latitude: 33.2082533 },
	{ name: "金剛福寺(３８番札所)" ,longitude: 133.0179593, latitude: 32.7255634 },
	{ name: "延光寺(３９番札所)" ,longitude: 132.7740647, latitude: 32.9613461 },
	{ name: "観自在寺(４０番札所)" ,longitude: 132.5640344, latitude: 32.9646878 },
	{ name: "龍光寺(４１番札所)" ,longitude: 132.5984997, latitude: 33.2952056 },
	{ name: "仏木寺(４２番札所)" ,longitude: 132.5815119, latitude: 33.3105756 },
	{ name: "明石寺(４３番札所)" ,longitude: 132.5202109, latitude: 33.3697887 },
	{ name: "大寶寺(４４番札所)" ,longitude: 132.9120864, latitude: 33.660933 },
	{ name: "岩屋寺(４５番札所)" ,longitude: 132.9810824, latitude: 33.6588982 },
	{ name: "浄瑠璃寺(４６番札所)" ,longitude: 132.8194588, latitude: 33.75341 },
	{ name: "八坂寺(４７番札所)" ,longitude: 132.8171862, latitude: 33.7573232 },
	{ name: "西林寺(４８番札所)" ,longitude: 132.8139542, latitude: 33.7937385 },
	{ name: "浄土寺(４９番札所)" ,longitude: 132.8083961, latitude: 33.8167083 },
	{ name: "繁多寺(５０番札所)" ,longitude: 132.8045047, latitude: 33.8281459 },
	{ name: "石手寺(５１番札所)" ,longitude: 132.7972693, latitude: 33.8476129 },
	{ name: "太山寺(５２番札所)" ,longitude: 132.7150915, latitude: 33.885172 },
	{ name: "円明寺(５３番札所)" ,longitude: 132.7400664, latitude: 33.8914788 },
	{ name: "延命寺(５４番札所)" ,longitude: 132.9640632, latitude: 34.0669654 },
	{ name: "南光坊(５５番札所)" ,longitude: 132.9955021, latitude: 34.068214 },
	{ name: "泰山寺(５６番札所)" ,longitude: 132.9745282, latitude: 34.0500383 },
	{ name: "栄福寺(５７番札所)" ,longitude: 132.978403, latitude: 34.029715 },
	{ name: "仙遊寺(５８番札所)" ,longitude: 132.977226, latitude: 34.0139089 },
	{ name: "国分寺(５９番札所)" ,longitude: 133.0254478, latitude: 34.0261928 },
	{ name: "横峰寺(６０番札所)" ,longitude: 133.111134, latitude: 33.837847 },
	{ name: "香園寺(６１番札所)" ,longitude: 133.1031043, latitude: 33.8937063 },
	{ name: "宝寿寺(６２番札所)" ,longitude: 133.1149071, latitude: 33.897306 },
	{ name: "吉祥寺(６３番札所)" ,longitude: 133.1291794, latitude: 33.8961064 },
	{ name: "前神寺(６４番札所)" ,longitude: 133.160499, latitude: 33.8918238 },
	{ name: "三角寺(６５番札所)" ,longitude: 133.586821, latitude: 33.967456 },
	{ name: "雲辺寺(６６番札所)" ,longitude: 133.723637, latitude: 34.035419 },
	{ name: "大興寺(６７番札所)" ,longitude: 133.7192046, latitude: 34.1021527 },
	{ name: "神恵院(６８番札所)" ,longitude: 133.647419, latitude: 34.133969 },
	{ name: "観音寺(６９番札所)" ,longitude: 133.647527, latitude: 34.134487 },
	{ name: "本山寺(７０番札所)" ,longitude: 133.6941085, latitude: 34.1397481 },
	{ name: "弥谷寺(７１番札所)" ,longitude: 133.7243978, latitude: 34.2300073 },
	{ name: "曼荼羅寺(７２番札所)" ,longitude: 133.7502389, latitude: 34.2233043 },
	{ name: "出釈迦寺(７３番札所)" ,longitude: 133.750203, latitude: 34.2194075 },
	{ name: "甲山寺(７４番札所)" ,longitude: 133.7657511, latitude: 34.2332538 },
	{ name: "善通寺(７５番札所)" ,longitude: 133.7740089, latitude: 34.2250187 },
	{ name: "金倉寺(７６番札所)" ,longitude: 133.7809635, latitude: 34.250069 },
	{ name: "道隆寺(７７番札所)" ,longitude: 133.7626177, latitude: 34.2764599 },
	{ name: "郷照寺(７８番札所)" ,longitude: 133.8245307, latitude: 34.3068002 },
	{ name: "天皇寺(７９番札所)" ,longitude: 133.8828232, latitude: 34.3114457 },
	{ name: "國分寺(８０番札所)" ,longitude: 133.94417, latitude: 34.3031243 },
	{ name: "白峯寺(８１番札所)" ,longitude: 133.9267457, latitude: 34.3336399 },
	{ name: "根香寺(８２番札所)" ,longitude: 133.960676, latitude: 34.3444442 },
	{ name: "一宮寺(８３番札所)" ,longitude: 134.0266248, latitude: 34.2866321 },
	{ name: "屋島寺(８４番札所)" ,longitude: 134.1012579, latitude: 34.3579444 },
	{ name: "八栗寺(８５番札所)" ,longitude: 134.1394657, latitude: 34.3598272 },
	{ name: "志度寺(８６番札所)" ,longitude: 134.1795768, latitude: 34.3243155 },
	{ name: "長尾寺(８７番札所)" ,longitude: 134.1714671, latitude: 34.2663552 },
	{ name: "大窪寺(８８番札所)" ,longitude: 134.2067671, latitude: 34.1914157 },
]

function putMarkers() {
    for (var i = 0; i < dataSet.length; i++) {
        var data = dataSet[i];
        var marker = WE.marker([data.latitude, data.longitude]).addTo(earth);
        marker.bindPopup(data.name, {
            maxWidth: 40,
            closeButton: false
        }).closePopup();
        markers.push(marker);
    }
}

function flyToJapan() {
    earth.panInsideBounds([
        [34 - 1.5, 134 - 1.5],
        [34 + 1.5, 134 + 1.5]
    ], {
        heading: 0,
        tilt: 40,
        duration: 2.0
    });
}

var pos = 0;
var oldpos = 0;
var timer = 0;

function letsGoTour() {
    pos = 0;
    // 1.5秒毎に滞在先を変更する
    timer = setInterval(stay, 1500);
}

function stay() {
    if (pos < dataSet.length) {
        var data = dataSet[pos];
        var oldmarker = markers[oldpos]
        oldmarker.closePopup();    // 前回のマーカーのポップアップをクローズする
        var marker = markers[pos]
        marker.openPopup();        // 現在のマーカーのポップアップを表示する
        earth.panInsideBounds([
            [data.latitude - 0.1, data.longitude - 0.1],
            [data.latitude + 0.1, data.longitude + 0.1]
        ], {
            heading: 0,
            tilt: 40,
            duration: 1
        });
        oldpos = pos;
        pos++;
    } else {
        clearInterval(timer);
        flyToJapan();
        var oldmarker = markers[oldpos]
        oldmarker.closePopup();    // 前回のマーカーのポップアップをクローズする
    }
}

initialize();
putMarkers();
flyToJapan();
